k6 `v0.52.0` is here 🎉! Some special mentions included in this release:

- [We've switched to our own fork of `goja` named `sobek`](#switch-goja-to-our-own-fork-named-sobek-3775).
- [Panics are no longer captured](#panics-are-no-longer-being-captured-3777).
- [We've added experimental support for TypeScript and ES6+](#experimental-support-for-typescript-and-es6-using-esbuild-3738).
- `k6/browser` has [graduated from an experimental module](#k6browser-has-graduated-from-an-experimental-module-3793), and now has a [fully Async API](#k6browser-has-now-a-fully-async-api-browser428).

## Breaking changes

### Switch `goja` to our own fork named `sobek` [#3775](https://github.com/grafana/k6/pull/3775)

To accelerate the development speed and bring ECMAScript Modules (ESM) support to k6 earlier (https://github.com/grafana/k6/issues/3265),
we have decided to create a fork of the [`goja`](https://github.com/dop251/goja/) project under the Grafana GitHub organization,
named [`sobek`](https://github.com/grafana/sobek).

Starting on this release, k6 (and its extensions) now use `sobek` instead of the original `goja`, for all (of the
publicly exposed parts of the API) except for a couple of packages that are only used internally by k6.

All k6 extensions linked in the docs have had a PR for this transition opened, as explained in this [comment](https://github.com/grafana/k6/issues/3773#issuecomment-2182113677). Any extension author who hasn't gotten a PR can follow the same steps.

Find further details in [#3772](https://github.com/grafana/k6/issues/3772) and [#3773](https://github.com/grafana/k6/issues/3773).

### Panics are no longer being captured [#3777](https://github.com/grafana/k6/pull/3777)

Since this release, Go panics are no longer being captured by k6. This means that if a panic occurs while running a test,
the k6 process will crash, and the panic stack trace will be printed to the console.

We decided to change this behavior because it's something that was left from the past as a safeguard, but it's not as
good as it might seem. For most cases with multiple goroutines/async, it's not enough and also makes a bunch of potential
bugs seem like less of an issue.

Thus, this will help us to identify and fix bugs earlier, improve the overall stability of k6, and
most likely make the experience of developing k6 extensions friendlier.

### `lib.State` no longer has `Group` [#3750](https://github.com/grafana/k6/pull/3750)

As the result of refactoring the implementation of `group` and `check` methods, in order to decouple them, and thus 
enable other future improvements, the `lib.State` object no longer has a `Group` field.

This change should not affect most users, except for a couple of extensions, for which the use of `Group` was
already questionable:
- `xk6-fasthttp`
- `xk6-g0`

### Other breaking changes

- [#3797](https://github.com/grafana/k6/pull/3797) starts using `-` as a special value for `--archive-out` to output the archive to stdout.
- [browser#1318](https://github.com/grafana/xk6-browser/pull/1318) makes the `Mouse.up` and `Mouse.down` methods no longer take x and y coordinates. Instead, they dispatch events on the current mouse position.

## New features

### Experimental support for TypeScript and ES6+ using esbuild [#3738](https://github.com/grafana/k6/pull/3738)

This release of k6 introduces experimental support for TypeScript and ES6+ using esbuild, thanks to a new
[compatibility mode](https://grafana.com/docs/k6/latest/using-k6/javascript-typescript-compatibility-mode/) named `experimental_enhanced`.

```sh
k6 run --compatibility-mode=experimental_enhanced script.js
```

With this new compatibility mode, the test source code is transformed using esbuild instead of Babel, which also means
that source files with the extension _".ts"_ are loaded by esbuild's TypeScript loader, which results in partial 
TypeScript support: it removes the type information but doesn't provide type safety.

### `k6/browser` has graduated from an experimental module [#3793](https://github.com/grafana/k6/pull/3793)

The browser module is now available as `k6/browser` instead of `k6/experimental/browser`. The previous `k6/experimental/browser` module will be removed on September 23rd, 2024. Refer to [the migration guide](https://grafana.com/docs/k6/latest/using-k6-browser/migrating-to-k6-v0-52/) for more information on how to update your scripts.

### `k6/browser` has now a fully Async API [browser#428](https://github.com/grafana/xk6-browser/issues/428)

This release introduces a fully Async API for the `k6/browser` module. This means that nearly all the methods in the module now return promises. This change is part of the ongoing effort to make the browser module more user-friendly and easier to use. Please see [the browser documentation](https://grafana.com/docs/k6/latest/javascript-api/k6-browser) for more information on how to use the new Async API.

Related Changes:
- [browser#1310](https://github.com/grafana/xk6-browser/pull/1310), [browser#1311](https://github.com/grafana/xk6-browser/pull/1311), [browser#1312](https://github.com/grafana/xk6-browser/pull/1312), [browser#1316](https://github.com/grafana/xk6-browser/pull/1316), [browser#1328](https://github.com/grafana/xk6-browser/pull/1328), [browser#1337](https://github.com/grafana/xk6-browser/pull/1337), [browser#1367](https://github.com/grafana/xk6-browser/pull/1367), [browser#1366](https://github.com/grafana/xk6-browser/pull/1366), [browser#1314](https://github.com/grafana/xk6-browser/pull/1314), [browser#1332](https://github.com/grafana/xk6-browser/pull/1332), [browser#1323](https://github.com/grafana/xk6-browser/pull/1323), [browser#1355](https://github.com/grafana/xk6-browser/pull/1355), [browser#1348](https://github.com/grafana/xk6-browser/pull/1348), [browser#1364](https://github.com/grafana/xk6-browser/pull/1364) Migrates `Browser`, `BrowserContext`, `ElementHandle`, `Frame`, `JSHandle`, `Keyboard`, `Locator`, `Mouse`, `Page`, `Request`, `Response` APIs to async.

## UX improvements and enhancements

- [#3740](https://github.com/grafana/k6/pull/3740) enables k6 extensions to initialize `ReadableStream` objects from Go code (`io.Reader`).
- [#3798](https://github.com/grafana/k6/pull/3798) adjusts a severity level of a log message from `warn` to `debug` for cases when k6 can't detect the terminal's size.
- [#3797](https://github.com/grafana/k6/pull/3797) makes it possible to output the archive to stdout by using `-` as the `--archive-out`. Thanks to @roobre! :bow: :tada:
- [browser#1370](https://github.com/grafana/xk6-browser/issues/1370) makes the `GetAttribute` method now return `false` when the attribute is missing, making it easier to check for the presence of an attribute.
- [browser#1371](https://github.com/grafana/xk6-browser/issues/1371) makes the `TextContent` method now return `false` when the element's text content cannot be grabbed (like a JS `document`), making it easier to check for the presence of text content.
- [browser#1376](https://github.com/grafana/xk6-browser/pull/1376) makes `Request.headerValue` and `Response.headerValue` to be case-insensitive.
- [browser#1368](https://github.com/grafana/xk6-browser/pull/1368) enhances `await` usage in Javascript examples.
- [browser#1326](https://github.com/grafana/xk6-browser/pull/1326) adds forgotten `BrowserContext.browser` and `Page.context` mappings.
- [browser#1360](https://github.com/grafana/xk6-browser/pull/1360), [browser#1327](https://github.com/grafana/xk6-browser/pull/1327), [browser#1335](https://github.com/grafana/xk6-browser/pull/1335), [browser#1365](https://github.com/grafana/xk6-browser/pull/1365), [browser#1313](https://github.com/grafana/xk6-browser/pull/1313), [browser#1322](https://github.com/grafana/xk6-browser/pull/1322), [browser#1330](https://github.com/grafana/xk6-browser/pull/1330), [browser#1343](https://github.com/grafana/xk6-browser/pull/1343), [browser#1345](https://github.com/grafana/xk6-browser/pull/1345), [browser#1352](https://github.com/grafana/xk6-browser/pull/1352) turns the `Browser`, `BrowserContext`, `ElementHandle`, `JSHandle`, `Keyboard`, `Mouse`, `Locator`, and `Page` types' panics into errors for stability and better error handling.

## Bug fixes

- [#3774](https://github.com/grafana/k6/pull/3774) fixes a `require` warning for those tests using the stdin.
- [#3776](https://github.com/grafana/k6/pull/3776) fixes a panic caused by passing an undefined handler to timers.
- [#3779](https://github.com/grafana/k6/pull/3779) fixes a panic caused by registering an undefined handler in gRPC streams.
- [xk6-websockets#73](https://github.com/grafana/xk6-websockets/pull/73) fixes a panic caused by registering an undefined handler in WebSockets.
- [browser#1369](https://github.com/grafana/xk6-browser/pull/1369) improves `valueFromRemoteObject` `null` detection by returning a Go `nil` instead of `"null"` as a `string`.
- [browser#1386](https://github.com/grafana/xk6-browser/pull/1386) correctly handles empty string flags that don't have a value.
- [browser#1380](https://github.com/grafana/xk6-browser/pull/1380) ensures that `JSHandle.evaluate` and `JSHandle.evaluateHandle` both set themselves as the first argument.
- [browser#1346](https://github.com/grafana/xk6-browser/pull/1346) fixes an IFrame panic ("we either navigate top level or have old version of the navigated frame") that happens during navigation.
- [browser#1349](https://github.com/grafana/xk6-browser/pull/1349), [browser#1354](https://github.com/grafana/xk6-browser/pull/1354) fixes `Request` mappings.
- [browser#1334](https://github.com/grafana/xk6-browser/pull/1334) fixes an issue where clicking on a link that opens a new tab never navigates to the href link.
- [browser#1318](https://github.com/grafana/xk6-browser/pull/1318) fixes the `Mouse.move` to correctly dispatch a `down` event.
- [browser#1301](https://github.com/grafana/xk6-browser/pull/1301) fixes an error that occurs when working with a second tab and navigating to a URL.
- [browser#1387](https://github.com/grafana/xk6-browser/pull/1387) fixes a panic when the new document or request is missing.

## Maintenance and internal improvements

- [#3752](https://github.com/grafana/k6/pull/3752), [#3767](https://github.com/grafana/k6/pull/3767), [#3770](https://github.com/grafana/k6/pull/3770), [#3780](https://github.com/grafana/k6/pull/3780), [#3782](https://github.com/grafana/k6/pull/3782), [#3795](https://github.com/grafana/k6/pull/3795) updates several dependencies.
- [#3786](https://github.com/grafana/k6/pull/3786), [#3787](https://github.com/grafana/k6/pull/3787), [#3788](https://github.com/grafana/k6/pull/3788), [#3789](https://github.com/grafana/k6/pull/3789), [#3803](https://github.com/grafana/k6/pull/3803) updates experimental modules.
- [#3749](https://github.com/grafana/k6/pull/3749) stops printing `goja` stack traces on panics, which has been empty since a while.
- [#3760](https://github.com/grafana/k6/pull/3760) fixes race conditions in ramping-vus tests.
- [#3769](https://github.com/grafana/k6/pull/3769) removes a linter setting no longer used.
- [#3800](https://github.com/grafana/k6/pull/3800) adds test coverage for outputting the archive to stdout.
- [browser#1298](https://github.com/grafana/xk6-browser/pull/1298) splits browser mappings into separate files for better organization and maintainability.
- [browser#1321](https://github.com/grafana/xk6-browser/pull/1321) adds test helpers for async VU execution to reduce the boilerplate in the tests.
- [browser#1357](https://github.com/grafana/xk6-browser/pull/1357) updates `Group` and `Tag` usage for the latest k6.
- [browser#1361](https://github.com/grafana/xk6-browser/pull/1361) precalculates the browser version information to prevent I/O calls when the `version` and `userAgent` methods are called. This change allows the browser module to expose these methods as a sync API to be consistent with the Playwright's API.
- [browser#1377](https://github.com/grafana/xk6-browser/pull/1377) uses the `goja` fork called `sobek` in the browser module.
- [browser#1373](https://github.com/grafana/xk6-browser/pull/1373) provides sync and async APIs within the browser module for making the migration to the async API easier.

## Roadmap

### Native ECMAScript modules

As mentioned above, the k6 team has forked [`goja`](https://github.com/dop251/goja/) into [`sobek`](https://github.com/grafana/sobek) and is currently working on [native ECMAScript modules support](https://github.com/grafana/k6/issues/3265). The current work in progress can be found in this [PR](https://github.com/grafana/k6/pull/3456) and any feedback is welcome.

As part of that there likely will be some breaking changes due to the current not native support allowing stuff that shouldn't work. Like for example mixing [CommonJS](https://en.wikipedia.org/wiki/CommonJS) and ESM in the same file. Which is for example why we have added a [warning](https://github.com/grafana/k6/pull/3807) that it won't work. 

Support across multiple files is *also* not standard but due to amount of users that seems to be mixing them *across* files a lot of work has been done to support it. It is still likely that in the future warnings and potentially at some point future breaking changes will be enacted.

### OpenTelemetry metrics output

We're also happy to share that this release cycle, we've been working on [xk6-output-opentelemetry](https://grafana.com/docs/k6/latest/results-output/real-time/opentelemetry/), a k6 output extension that allows you to send k6 metrics to OpenTelemetry-compatible backends. We're looking for feedback from the community. If you're interested, please try it and let us know [via the extension repository](https://github.com/grafana/xk6-output-opentelemetry/issues)!

Depending on the feedback, we plan to include this extension as an experimental output in the next k6 release.
